function graphE(sys,E,param)
% GRAPHE trace l'nergie potentielle considre ainsi qu'un
% paramtre (le plus intressant tant le facteur de transmission en
% probabilit, T) en fonction des diffrentes valeurs de l'nergie.  
%   GRAPHE(sys,E,param)
%       >>  sys : systme {nergie potentielle-objet physique}
%       >>  E : valeurs des nergies
%       >>  param : paramtre  tracer.
%       <<  Figure graphique (param,E)
%
% Olivier Pujol : septembre 2013
%
%%
if (nargin~=3);error('Mauvais nombre d''arguments d''entre !');end
if (isa(sys,'cell')==0),error('Le premier argument doit tre du type ''cellule'' !');end
%
L=get(sys{1}{length(sys{1})},'Position')-get(sys{1}{2},'Position');
xmin=get(sys{1}{2},'Position')-0.5*L;
xmax=get(sys{1}{length(sys{1})},'Position')+0.5*L;
clear L
%
pos=nan(1,length(sys{1})-1);    % Initialisation
Ep=nan(1,length(sys{1})-1);     % Initialisation
%
for i=2:length(sys{1})
    if (isa(sys{1}{i},'marche')==0),error('Mauvais type d''argument !');end
    pos(i-1)=get(sys{1}{i},'Position');
    Ep(i-1)=get(sys{1}{i},'EnergiePotentielleSortie');
end
%
pos=[xmin pos xmax];
Ep_e=sys{1}{1}(1);
Ep_s=sys{1}{1}(2);
Ep=[Ep_e Ep Ep_s];
%
figure;
subplot(1,2,1)
hs=stairs(pos,Ep);
set(hs,'LineWidth',2,'Color','b');
axis([xmin xmax min(Ep) max(E)]);
set(gca,'xminortick','on','yminortick','on');
grid on;
box on
xlabel('{\itx} (nm)');
title('Energie potentielle (eV)');

subplot(1,2,2);
plot(param,E);
set(gca,'xminortick','on','yminortick','on');
grid on;
box on
axis tight
labelx=input('Symbole du paramtre  tracer en fonction de l''nergie : ');
xlabel(labelx);
ylabel('{\itE} (eV)');
%
return;